import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
import easygui
import os
from pathlib import Path
from tkinter.filedialog import askopenfilename
import tkinter as tk

#input boxs para captura de encabezados de columna x y y
Name_of_your_Graph = easygui.enterbox(" Ingrese un nombre de la Grafica")
Nombre_x = easygui.enterbox("Ingrese el nombre de la columna de las X, ejemplo: X ")
Nombre_y = easygui.enterbox("Ingrese el nombre de la columna de las Y, ejemplo: Y ")

#Browser y lectura de archivo con datos
filename = askopenfilename(title=' eygop : Selecciona el fichero (.CSV) ', filetypes=[('All Files', '*')])
f = open (filename,'r') # con la variable que contiene la ruta y el nombre del archivo
data = pd.read_csv(filename) #lectura del fichero excel .csv

x = data[Nombre_x]
y = data[Nombre_y]

def linear_regression(x, y):     
    N = len(x)
    x_mean = x.mean()
    y_mean = y.mean()
    
    B1_num = ((x - x_mean) * (y - y_mean)).sum()
    B1_den = ((x - x_mean)**2).sum()
    B1 = B1_num / B1_den
    
    B0 = y_mean - (B1*x_mean)
    
    reg_line = 'y = {} + {}β'.format(B0, round(B1, 3))
    
    return (B0, B1, reg_line)

def corr_coef(x, y):
    N = len(x)
    
    num = (N * (x*y).sum()) - (x.sum() * y.sum())
    den = np.sqrt((N * (x**2).sum() - x.sum()**2) * (N * (y**2).sum() - y.sum()**2))
    R = num / den
    return R

B0, B1, reg_line = linear_regression(x, y)
print('Linea de Regresion : ', reg_line)
R = corr_coef(x, y)
print('Coeficiente de Correlacion  .................: ', R)
print('Ajuste de bondad ............................: ', R**2)

import tkinter 

interfaz = tkinter.Tk()
interfaz.title ("ventana de resultado, Regresion Simple ")
interfaz.geometry ("800x400")
interfaz.attributes("-topmost", True)

DATOS = "Linea de Regresion :\n"+ str(data)
RL = "Linea de Regresion ...............................: "+ str(reg_line)
CO = "Coeficiente de Correlacion ....................: "+ str(R)
GF = "Ajuste de bondad ................................................: "+ str(R**2)

labelExample = tkinter.Label (interfaz, text = DATOS, fg="black")
labelExample.grid (column = 0, row =0 , sticky = "W", pady = 1)

labelExample = tkinter.Label (interfaz, text = RL, fg="black")
labelExample.grid (column = 0, row =2 , sticky = "W", pady = 1)

labelExample = tkinter.Label (interfaz, text = CO, fg="black")
labelExample.grid (column = 0, row =4 , sticky = "W", pady = 1)

labelExample = tkinter.Label (interfaz, text = GF, fg="black")
labelExample.grid (column = 0, row =6 , sticky = "W", pady = 1)

plt.figure(figsize=(12,5))
plt.scatter(x, y, s=300, linewidths=1, edgecolor='black')
text = '''X Media: {} en Tiempo
Y Media: ${}
R: {}
R^2: {}
y = {} + {}X'''.format(round(x.mean(), 2), 
                       round(y.mean(), 2), 
                       round(R, 4), 
                       round(R**2, 4),
                       round(B0, 3),
                       round(B1, 3))
plt.text(x=1, y=100000, s=text, fontsize=12, bbox={'facecolor': 'grey', 'alpha': 0.2, 'pad': 10})
plt.title(Name_of_your_Graph)
plt.xlabel('Eje X', fontsize=15)
plt.ylabel('Eje Y', fontsize=15)
plt.plot(x, B0 + B1*x, c = 'r', linewidth=5, alpha=.5, solid_capstyle='round')
plt.scatter(x=x.mean(), y=y.mean(), marker='*', s=10**2.5, c='r') # average point
plt.show()

interfaz.mainloop()

